<?php 
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    
    session_start();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    $nome            = filter_input(INPUT_POST,'nome',FILTER_SANITIZE_ADD_SLASHES);
    $cognome         = filter_input(INPUT_POST,'cognome',FILTER_SANITIZE_ADD_SLASHES);
    $email           = filter_input(INPUT_POST,'email',FILTER_SANITIZE_EMAIL);
    $password        = hash("sha512",filter_input(INPUT_POST,'password'));
    $urlPiattaforma  = filter_input(INPUT_POST,'urlPiattaforma',FILTER_SANITIZE_URL);
    $nomePiattaforma = filter_input(INPUT_POST,'nomePiattaforma',FILTER_SANITIZE_ADD_SLASHES);
    $cartellaAmministrazione = filter_input(INPUT_POST,'cartellaAmministrazione',FILTER_SANITIZE_ADD_SLASHES);
    $linkAreaRiservata       = "$urlPiattaforma/$cartellaAmministrazione";
    
    if(isset($_POST["attivaContabilita"])) {
        $attivaContabilita = filter_input(INPUT_POST,'attivaContabilita',FILTER_SANITIZE_ADD_SLASHES);
        $tipoContabilita   = filter_input(INPUT_POST,'tipoContabilita',FILTER_SANITIZE_ADD_SLASHES);
    }
    else {
        $attivaContabilita = "";
        $tipoContabilita   = "";
    }
            
    // array contenente tutte le query per creare le tabelle, che poi verranno passate al dbManager che le eseguirà in blocco
    $queryCreazioniTabelle = array();
    
    //query per creare la tabella dei componenti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_impostazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `attivaHttps` varchar(55) NOT NULL,
        `logo` VARCHAR( 255 ) NOT NULL ,
        `logoMobile` VARCHAR( 255 ) NOT NULL ,
        `dimensioneAreaLogin` VARCHAR( 255 ) NOT NULL ,
        `titoloAreaLogin` VARCHAR( 255 ) NOT NULL ,
        `testoAreaLogin` TEXT( 65000 ) NOT NULL ,
        `menuSceltaLingue` VARCHAR(55) NOT NULL,
        `attivaFortino` VARCHAR(55) NOT NULL,
        `parolaChiaveFortino` varchar(55) NOT NULL,
        `tipoRedirectLogin` VARCHAR( 255 ) NOT NULL ,
        `linkPersonalizzatoLogin` VARCHAR( 255 ) NOT NULL ,        
        `paginaLogin` INT(11) NOT NULL,
        `paginaLoginEn` INT(11) NOT NULL,
        `paginaRegistrazione` INT(11) NOT NULL,
        `paginaRegistrazioneEn` INT(11) NOT NULL,
        `homePage` INT(11) NOT NULL,
        `homePageEn` INT(11) NOT NULL,
        `mostraProfilo` VARCHAR(55) NOT NULL,
        `paginaProfilo` INT(11) NOT NULL,
        `paginaProfiloEn` INT(11) NOT NULL,
        `paginaRecuperoPassword` INT(11) NOT NULL,
        `paginaRecuperoPasswordEn` INT(11) NOT NULL,
        `paginaNotifiche` INT(11) NOT NULL,
        `paginaNotificheEn` INT(11) NOT NULL,
        `urlPiattaforma` varchar(255) NOT NULL,
        `nomePiattaforma` varchar(255) NOT NULL,
        `descrizioneSito` varchar(255) NOT NULL,
        `consentiIndicizzazione` varchar(255) NOT NULL,
        `ottimizzazioneUrl` varchar(255) NOT NULL,
        `attivaCache` varchar(255) NOT NULL,
        `linguaSito` varchar(255) NOT NULL,
        `nomeMittente` VARCHAR (255) NOT NULL,
        `emailMittente` VARCHAR (255) NOT NULL,
        `utenteSmtp` VARCHAR (255) NOT NULL,
        `hostSmtp` VARCHAR (255) NOT NULL,
        `portaSmtp` SMALLINT (6) NOT NULL,
        `passwordSmtp` VARCHAR (255) NOT NULL,
        `disattivaAccessoUtenti` VARCHAR(55) NOT NULL,
        `messaggioAccessoDisattivato` VARCHAR(255) NOT NULL,
        `registrazioneUtenti` VARCHAR(255) NOT NULL,
        `gruppoDefault` INT(11) NOT NULL,
        `statoInizialeNuoviUtenti` VARCHAR(55) NOT NULL,
        `mailNotifiche` VARCHAR (255) NOT NULL ,
        `inviaNotificaMailNuovoUtente` VARCHAR (55) NOT NULL ,
        `inviaNotificaMailNuoveComunicazioni` VARCHAR(55) NOT NULL,
        `accessoFacebook` VARCHAR(255) NOT NULL,
        `accessoGoogle` VARCHAR(255) NOT NULL,
        `coloreBarraSuperiore` varchar(255) NOT NULL,
        `coloreTestoBarraSuperiore` varchar(255) NOT NULL,
        `attivaApi` VARCHAR(255) NOT NULL,
        `emailApi` VARCHAR(255) NOT NULL,
        `idAppFacebook` VARCHAR (255) NOT NULL ,
        `secretAppFacebook` VARCHAR (255) NOT NULL ,
        `filtraggioIP` VARCHAR( 55 ) NOT NULL ,
        `indirizziIPAmmessi` TEXT( 65000 ) NOT NULL ,
        `indirizziIPBannati` TEXT( 65000 ) NOT NULL ,
        `filtraggioIPAreaUtenti` VARCHAR( 55 ) NOT NULL ,
        `indirizziIPAmmessiAreaUtenti` TEXT( 65000 ) NOT NULL ,
        `indirizziIPBannatiAreaUtenti` TEXT( 65000 ) NOT NULL ,
        `cambioPasswordObbligatorio` VARCHAR( 55 ) NOT NULL ,
        `attivaContabilita` VARCHAR( 55 ) NOT NULL ,
        `tipoContabilita` VARCHAR( 55 ) NOT NULL ,
        `percentualeIva` VARCHAR( 55 ) NOT NULL ,
        `intestazioneDocumentiFiscali` TEXT (1000),
        `gruppoClienti` INT ( 11 ) NOT NULL ,
        `gruppoFornitori` INT ( 11 ) NOT NULL ,
        `ottimizzaImmaginiCaricate` VARCHAR( 55 ) NOT NULL ,
        `altezzaImmagine` SMALLINT( 6 ) NOT NULL ,
        `generaThumbnail` VARCHAR( 55 ) NOT NULL ,
        `altezzaThumbnail` SMALLINT( 6 ) NOT NULL ,
        `comprimiCss` VARCHAR( 55 ) NOT NULL ,
        `comprimiJs` VARCHAR( 55 ) NOT NULL ,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    //query per creare la tabella delle impostazioni delle lingue
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_impostazioniLingue` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `linguaPrincipale` VARCHAR(255) NOT NULL ,
        `impostazioniItaliano` VARCHAR(255) NOT NULL ,
        `menuItaliano` INT(11) NOT NULL ,
        `impostazioniInglese` VARCHAR(255) NOT NULL ,
        `menuInglese` INT(11) NOT NULL ,
        `impostazioniTedesco` VARCHAR(255) NOT NULL ,
        `menuTedesco` INT(11) NOT NULL ,        
        `impostazioniFrancese` VARCHAR(255) NOT NULL ,
        `menuFrancese` INT(11) NOT NULL ,
        `impostazioniSpagnolo` VARCHAR(255) NOT NULL ,
        `menuSpagnolo` INT(11) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella dei componenti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_componenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `componenteArticolo` VARCHAR( 255 ) NOT NULL ,
        `icona` VARCHAR( 255 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `paginaGestione` VARCHAR( 255 ) NOT NULL,
        `tabellaRiferimento` VARCHAR( 255 ) NOT NULL,
        `script` VARCHAR( 255 ) NOT NULL,
        `versione` VARCHAR( 255 ) DEFAULT '',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    // query per creare la tabella per comporre gli elementi del layout. Per elementi si intendono
    // il pannello laterale di destra, la barra superiore e il footer
    // ogni componente è ordinabile
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_composizioneElementi` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `idComponente` INT( 11 ) NOT NULL ,
        `idElemento` INT( 11 ) NOT NULL ,
        `pannello` VARCHAR( 255 ) NOT NULL ,
        `testo` VARCHAR( 255 ) NOT NULL ,
        `posizione` TINYINT( 11 ) NOT NULL ,
        `nomeDaMostrare` VARCHAR( 255 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella della colonna laterale di sinistra che consente di capire quali componenti 
    //mostrare a lato e in che ordine
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_composizionePagine` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `idComponente` INT( 11 ) NOT NULL ,
        `idPagina` INT( 11 ) NOT NULL ,
        `tipoElemento` VARCHAR( 255 ) NOT NULL ,
        `idElemento` INT( 11 ) NOT NULL ,
        `posizione` TINYINT( 11 ) NOT NULL ,
        `testo` TEXT( 65000 ) ,
        `codiceGenerato` TEXT( 65000 ) ,
        `script` TEXT( 65000 ) ,
        `idSezione` VARCHAR( 255 ) DEFAULT '' ,
        `classeSezione` VARCHAR( 255 ) DEFAULT '' ,
        `aTuttaLarghezza` VARCHAR( 55 ) DEFAULT '' ,
        `margineSezione` VARCHAR( 255 ) DEFAULT '' ,
        `paddingSezione` VARCHAR( 255 ) DEFAULT '' ,
        `animazione` VARCHAR( 255 ) DEFAULT '' ,
        `coloreSfondo` VARCHAR( 255 ) DEFAULT '' ,
        `immagineSfondo` VARCHAR( 255 ) DEFAULT '' ,
        `videoSfondo` VARCHAR( 255 ) DEFAULT '' ,
        `altreOpzioni` TEXT( 65000 ),
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    // query per creare la tabella contenuti, che contiene pagine, gallerie e articoli ed
    // elementi portfolio. Gallerie ed elementi portfolio lasceranno alcuni campi vuoti
    // 
    // il campo posizione ad esempio è utilizzato solo dal portfolio
    // cosi come il campo tipoVisualizzazione è usato solo dalla galleria
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_contenuti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `contenutoRiferimento` INT( 11 ) NOT NULL,
        `linguaContenuto` VARCHAR( 55 ) NOT NULL ,
        `tipo` VARCHAR( 55 ) NOT NULL ,
        `privato` VARCHAR( 255 ) NOT NULL ,
        `posizione` INT( 11 ) NOT NULL,
        `categoria` INT( 11 ) NOT NULL,
        `mostraNellaHome` VARCHAR( 255 ) NOT NULL ,
        `stato` VARCHAR( 255 ) NOT NULL ,
        `punteggioSeo` VARCHAR( 255 ) NOT NULL ,
        `template` VARCHAR( 255 ) NOT NULL ,
        `attivaBreadcrumbs` VARCHAR( 255 ) NOT NULL ,
        `tipoVisualizzazione` VARCHAR( 255 ) NOT NULL ,
        `titolo` VARCHAR( 255 ) NOT NULL ,
        `metaTitolo` VARCHAR( 255 ) NOT NULL ,
        `mostraTitolo` VARCHAR( 255 ) NOT NULL ,
        `metaDescrizione` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) NOT NULL ,
        `alias` VARCHAR( 255 ) NOT NULL ,
        `cssGenerato` TEXT( 65000 ) NOT NULL ,
        `cssAggiuntivo` TEXT( 65000 ) NOT NULL ,
        `testo` TEXT( 65000 ) NOT NULL ,
        `abilitaCommenti` VARCHAR( 255 ) NOT NULL ,
        `numeroVisite` INT( 11 ) NOT NULL ,
        `foto` VARCHAR( 255 ) NOT NULL ,
        `miniaturaFoto` VARCHAR( 255 ) NOT NULL ,
        `etichettaImmagine` VARCHAR(255) NOT NULL, 
        `autore` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL ,
        `dataUltimaVisita` DATE NOT NULL ,
        `dataUltimaModifica` DATE NOT NULL ,
        `dataPubblicazione` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_visiteGiornaliere` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `numeroVisite` VARCHAR( 255 ) NOT NULL ,
        `dataCorrente` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
        
    /*
     * query creazione tabella per memorizzare le preferenze sui cookie
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_leggeCookie` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `lingua` VARCHAR( 55 ) NOT NULL,
        `attivaBarraCookie` VARCHAR( 55 ) NOT NULL,
        `durataCookie` SMALLINT( 6 ) NOT NULL,
        `testoBarraCookie` TEXT( 1000 ) NOT NULL,
        `headCodiciCookie` TEXT( 1000 ) NOT NULL,
        `fineBodyCookie` TEXT( 1000 ) NOT NULL,
        `testoPulsanteAccetto` VARCHAR( 255 ) NOT NULL,
        `testoPulsanteNonAccetto` VARCHAR( 255 ) NOT NULL,
        `testoPulsanteMaggioriInformazioni` VARCHAR( 255 ) NOT NULL,
        `mostraPulsanteNonAccetto` VARCHAR( 255 ) NOT NULL,
        `mostraPulsanteMaggioriInformazioni` VARCHAR( 255 ) NOT NULL,
        `paginaMaggioriInformazioni` INT(11) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella comunicazioni
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_comunicazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idUtente` INT( 11 ) NOT NULL ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `stato` VARCHAR( 255 ) NOT NULL ,
        `priorita` VARCHAR( 255 ) NOT NULL ,
        `template` VARCHAR( 255 ) NOT NULL ,
        `oggetto` VARCHAR( 255 ) NOT NULL ,
        `testo` TEXT( 65535 ) NOT NULL ,
        `autore` VARCHAR( 255 ) NOT NULL ,
        `inviaEmail` VARCHAR( 255 ) NOT NULL ,
        `inviaNotifica` VARCHAR( 255 ) NOT NULL ,
        `efficacia` VARCHAR( 255 ) NOT NULL ,
        `mailInviate` INT( 11 ) NOT NULL ,
        `mailNonInviate` INT( 11 ) NOT NULL ,
        `logInvio` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATETIME NOT NULL ,
        `dataInvio` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    // query per creare la tabella che memorizza i componenti della singola comunicazione (solo quando
    // si tratta di una comunicazione di tipo "comunicazione", che viene creata dagli amministratori
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecAd_composizioneComunicazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idComunicazione` INT( 11 ) NOT NULL,
        `idComponente` INT( 11 ) NOT NULL,
        `testo` TEXT( 65000 ) NOT NULL,
        `posizione` TINYINT( 4 ) NOT NULL ,
        `altreOpzioni` TEXT( 65000 ),
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella degli allegati delle comunicazioni
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_allegatiComunicazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idComunicazione` INT( 11 ) NOT NULL ,
        `percorso` TEXT( 65535 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
                
    //query per creare la tabella risposteTicket
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_risposteTicket` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idTicket` INT( 11 ) NOT NULL ,
        `testo` TEXT( 65535 ) NOT NULL ,
        `autore` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella dei gruppi
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_gruppiDestinatari` (
            `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
            `idComunicazione` INT( 11 ) NOT NULL ,
            `idRisorsa` INT( 11 ) NOT NULL ,
            `idGruppoDestinatario` INT( 11 ) NOT NULL ,
            PRIMARY KEY ( `id` )
        )ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare i documenti fiscali: preventivi, fatture, riceveute e voci prima nota
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_documentiContabili` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `numeroDocumento` INT( 11 ) NOT NULL,
        `idUtente` INT( 11 ) NOT NULL,
        `tipo` VARCHAR (255) NOT NULL ,
        `entrataUscita` VARCHAR (55) NOT NULL ,
        `etichetta` VARCHAR (255) NOT NULL ,
        `numero` INT( 11 ) NOT NULL,
        `oggetto` VARCHAR (255) NOT NULL ,
        `testo` TEXT (65000) NOT NULL ,
        `imponibile` DOUBLE( 10,2 ) NOT NULL,
        `iva` DOUBLE( 10,2 ) NOT NULL,
        `totale` DOUBLE( 10,2 ) NOT NULL,
        `metodoPagamento` VARCHAR( 55 ) NOT NULL,
        `stato` VARCHAR( 55 ) NOT NULL,
        `giorniNecessari` SMALLINT( 6 ) NOT NULL,
        `giorniValidita` SMALLINT( 6 ) NOT NULL,
        `dataEmissione` DATE NOT NULL,
        `dataPagamento` DATE, 
        `dataAccettazione` DATE,
        PRIMARY KEY (`id`)
        )ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare le singole voci di fatture e ricevure
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_vociDocumentiContabili` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idDocumento` INT( 11 ) NOT NULL,
        `descrizione` VARCHAR (255) NOT NULL ,
        `quantita` SMALLINT(6) NOT NULL,
        `prezzo` DOUBLE(10,2) NOT NULL,
        `iva` TINYINT (4) NOT NULL,
        `totaleParziale` DOUBLE(10,2) NOT NULL,
        PRIMARY KEY (`id`)
        )ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare voci predefinite di fatture e ricevure
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_vociDocumentiContabiliPredefinite` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `descrizione` VARCHAR (255) NOT NULL ,
        `prezzo` DOUBLE(10,2) NOT NULL,
        `iva` TINYINT (4) NOT NULL,
        PRIMARY KEY (`id`)
        )ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
        
    /*
     * query creazione tabella per memorizzare le impostazioni del footer
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_footer` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `lingua` VARCHAR( 55 ) NOT NULL,
        `testo` TEXT( 65000 ) NOT NULL,
        `attivaFooterSuperiore` TEXT( 65000 ) NOT NULL,
        `numeroColonne` TEXT( 1000 ) NOT NULL,
        `colonna1` VARCHAR( 255 ) NOT NULL,
        `colonna2` VARCHAR( 255 ) NOT NULL,
        `colonna3` VARCHAR( 255 ) NOT NULL,
        `colonna4` VARCHAR( 255 ) NOT NULL,
        `titoloColonna1` VARCHAR( 255 ) NOT NULL,
        `titoloColonna2` VARCHAR( 255 ) NOT NULL,
        `titoloColonna3` VARCHAR( 255 ) NOT NULL,
        `titoloColonna4` VARCHAR( 255 ) NOT NULL,
        `coloreFooterInferiore` VARCHAR( 255 ) NOT NULL,
        `coloreFooterSuperiore` VARCHAR( 255 ) NOT NULL,
        `coloreTestiMenu` VARCHAR( 255 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query per la creazione delle query comuni
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_inclusioni` (
      `id` INT(11) NOT NULL AUTO_INCREMENT,
      `inizioHead` TEXT(65000) NOT NULL,
      `fineHead` TEXT(65000) NOT NULL,
      `inizioBody` TEXT(65000) NOT NULL,
      `fineBody` TEXT(65000) NOT NULL,
      `footer` TEXT(65000) NOT NULL,
    PRIMARY KEY ( `id` )
    ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    // query per creare la tabella delle etichette, utilizzata per le voci in contabilità nella prima nota e per gli utenti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_etichette` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    // query per creare la tabella moduliRegistrazione, che contiene sia pagine che gallerie
    // gallerie lascerà alcuni campi vuoti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_moduliRegistrazione` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR (255) NOT NULL ,
        `richiediNome` VARCHAR (255) NOT NULL ,
        `richiediCognome` VARCHAR (255) NOT NULL ,
        `richiediCitta` VARCHAR (255) NOT NULL ,
        `richiediOrganizzazione` VARCHAR (255) NOT NULL ,
        `richiediCodiceFiscale` VARCHAR (255) NOT NULL ,
        `richiediPartitaIva` VARCHAR (255) NOT NULL ,
        `richiediEmail` VARCHAR (255) NOT NULL ,
        `richiediTelefono` VARCHAR (255) NOT NULL ,
        `richiediPassword` VARCHAR (255) NOT NULL ,
        `richiediGruppo` VARCHAR (255) NOT NULL ,
        `gruppoObbligatorio` VARCHAR (255) NOT NULL ,
        `inviaMailConferma` VARCHAR (255) NOT NULL ,
        `inviaPasswordViaEmail` VARCHAR (255) NOT NULL ,
        `contenutoEmailRegistrazione` VARCHAR (255) NOT NULL ,
        `inviaNotificaNuovoUtente` VARCHAR (255) NOT NULL ,
        `mailNotificheNuoviUtenti` VARCHAR (255) NOT NULL ,
        PRIMARY KEY ( `id` )
        )ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella delle voci di menu
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_menu` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `formRicerca` VARCHAR( 55 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    //query per creare la tabella delle voci di menu
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_vociMenu` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idMenu` INT( 11 ) NOT NULL,
        `idContenuto` INT( 11 ) NOT NULL,
        `vocePadre` INT( 11 ) NOT NULL,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `icona` VARCHAR( 255 ) NOT NULL ,
        `immagine` VARCHAR( 255 ) NOT NULL ,
        `tipo` VARCHAR( 255 ) NOT NULL ,
        `link` VARCHAR( 255 ) NOT NULL,
        `posizione` INT( 11 ) NOT NULL,
        `gruppoSpecifico` INT( 11 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella risorse
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_risorse` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idUtente` INT( 11 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `password` VARCHAR( 255 ) NOT NULL ,
        `percorso` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) NOT NULL ,
        `immagine` VARCHAR( 255 ) NOT NULL ,
        `categoria` INT( 11 ) NOT NULL ,
        `accessibilita` VARCHAR( 55 ) NOT NULL ,
        `posizione` INT( 11 ) NOT NULL ,
        `numeroDownload` INT( 11 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare i moduli di contatto
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_cruscotti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR( 55 ) DEFAULT 'col-12' ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare gli elementi presenti in un cruscotto
     */
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geec_elementiCruscotto` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `idCruscotto` INT(11) NOT NULL,
        `posizione` tinyINT(4) NOT NULL,
        `spazioOccupato` VARCHAR( 55 ) DEFAULT 'col-12' ,
        `nome` varchar(255) NOT NULL,
        `coloreSfondo` varchar(255) NOT NULL,
        `coloreTesti` varchar(255) NOT NULL,
        `classiAggiuntive` varchar(255) NOT NULL,
        `icona` varchar(255) NOT NULL,
        `stile` varchar(255) NOT NULL,
        `stilePulsanti` varchar(255) NOT NULL,
        `etichettaPulsante1` varchar(255) NOT NULL,
        `etichettaPulsante2` varchar(255) NOT NULL,
        `linkPulsante1` varchar(255) NOT NULL,
        `linkPulsante2` varchar(255) NOT NULL,
        `valoreMostrato` varchar(255) NOT NULL,
        `valoreDaMostrare` varchar(255) NOT NULL,
        `query` varchar(255) NOT NULL,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    /*
     * query per la creazione delle query comuni
     */
    $queryTabelleComuni = array();
    //query per creare la tabella utenti
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_utenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `email` VARCHAR( 255 ) NOT NULL ,
        `password` VARCHAR( 255 ) NOT NULL ,
        `ruolo` VARCHAR( 255 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `cognome` VARCHAR( 255 ) NOT NULL ,
        `sesso` VARCHAR( 55 ) NOT NULL ,
        `foto` VARCHAR( 255 ) NOT NULL ,
        `descrizione` TEXT( 5000 ) NOT NULL ,
        `note` TEXT( 1000 ) NOT NULL ,
        `via` VARCHAR( 255 ) NOT NULL ,
        `citta` VARCHAR( 255 ) NOT NULL ,
        `cap` VARCHAR( 255 ) NOT NULL ,
        `dataNascita` DATE ,
        `luogoNascita` VARCHAR( 255 ) NOT NULL ,
        `provinciaNascita` VARCHAR( 255 ) NOT NULL ,
        `telefono` VARCHAR( 255 ) NOT NULL ,
        `codiceFiscale` VARCHAR( 255 ) NOT NULL ,
        `partitaIva` VARCHAR( 255 ) NOT NULL,
        `organizzazione` VARCHAR( 255 ) NOT NULL,
        `sitoWeb` VARCHAR( 255 ) NOT NULL ,
        `pec` VARCHAR( 255 ) NOT NULL ,
        `codiceInterscambio` VARCHAR( 255 ) NOT NULL ,
        `stato` VARCHAR( 255 ) NOT NULL ,
        `ricezioneMail` VARCHAR( 255 ) NOT NULL ,
        `etichetta` VARCHAR( 255 ) NOT NULL ,
        `dataCreazione` DATE NOT NULL,
        `ultimoLogin` DATE NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    /*
     * query creazione tabella per memorizzare le configurazioni del colore
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_configurazioniAspetto` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR (255) NOT NULL,
        `descrizione` VARCHAR (255) NOT NULL,
        `selezionataCms` VARCHAR (255) NOT NULL,
        `selezionataAdmin` VARCHAR (255) NOT NULL,
        `selezionataDoc` VARCHAR (255) NOT NULL,
        `logo` VARCHAR (255) NOT NULL,
        `logoMobile` VARCHAR (255) NOT NULL,
        `favicon` VARCHAR (255) NOT NULL,
        `sfondoBarraMenu` VARCHAR (255) NOT NULL,
        `coloreTestoBarraMenu` VARCHAR (255) NOT NULL,
        `linkFont` VARCHAR (255) NOT NULL,
        `fontIntestazioni` VARCHAR (255) NOT NULL,
        `fontTesti` VARCHAR (255) NOT NULL,
        `colorePrimario` VARCHAR (255) NOT NULL,
        `coloreSecondario` VARCHAR (255) NOT NULL,
        `coloreSuccess` VARCHAR (255) NOT NULL,
        `coloreInfo` VARCHAR (255) NOT NULL,
        `coloreLight` VARCHAR (255) NOT NULL,
        `coloreDark` VARCHAR (255) NOT NULL,
        `coloreWarning` VARCHAR (255) NOT NULL,
        `coloreDanger` VARCHAR (255) NOT NULL,
        `colorePrimarioHover` VARCHAR (255) NOT NULL,
        `coloreSecondarioHover` VARCHAR (255) NOT NULL,
        `coloreSuccessHover` VARCHAR (255) NOT NULL,
        `coloreInfoHover` VARCHAR (255) NOT NULL,
        `coloreLightHover` VARCHAR (255) NOT NULL,
        `coloreDarkHover` VARCHAR (255) NOT NULL,
        `coloreWarningHover` VARCHAR (255) NOT NULL,
        `coloreDangerHover` VARCHAR (255) NOT NULL,
        `colorePrimarioActive` VARCHAR (255) NOT NULL,
        `coloreSecondarioActive` VARCHAR (255) NOT NULL,
        `coloreSuccessActive` VARCHAR (255) NOT NULL,
        `coloreInfoActive` VARCHAR (255) NOT NULL,
        `coloreLightActive` VARCHAR (255) NOT NULL,
        `coloreDarkActive` VARCHAR (255) NOT NULL,
        `coloreWarningActive` VARCHAR (255) NOT NULL,
        `coloreDangerActive` VARCHAR (255) NOT NULL,
        `breakingPointsXs` VARCHAR (255) NOT NULL,
        `breakingPointsMd` VARCHAR (255) NOT NULL,
        `breakingPointsLg` VARCHAR (255) NOT NULL,
        `breakingPointsXl` VARCHAR (255) NOT NULL,
        `attivaColonnaSinistra` VARCHAR (255) NOT NULL,
        `colonnaSinistra` VARCHAR (255) NOT NULL,
        `colonnaCentrale` VARCHAR (255) NOT NULL,
        `attivaColonnaDestra` VARCHAR (255) NOT NULL,
        `colonnaDestra` VARCHAR (255) NOT NULL,
        `aspettoComponentiLaterali` VARCHAR (255) NOT NULL,
        PRIMARY KEY ( `id` )
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
        // query per inserire le configurazioni dell'aspetto: logo, colori e altre impostazioni
    $queryTabelleComuni[count($queryTabelleComuni)] = "INSERT INTO `geec_configurazioniAspetto`  
        VALUES (1, 'Configurazione di base','Stai usando la configurazione predefinita dei colori di Geecom', 'no','si','no','template/logoGeecom.svg','template/logo-mobile.svg','template/favicon.ico', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap','font-family:\'Raleway\', sans-serif;','font-family:\'Roboto\', sans-serif;', '#018394', '#dd3b15', '#28a745', '#335C67', '#f8f9fa', '#0d1b1e', '#f7a616', '#dc3545','#016c7a', '#b53112', '#218838', '#2f5453', '#e2e6ea', '#0c191c','#cb8813', '#c82333','#01606c', '#a12b10', '#1e7e34','#2a4c55', '#dae0e5', '#0b1719', '#b47b11', '#bd2130','576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (2, 'Monocromo Verde', 'Stai usando la configurazione Monocromo Verde, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no','no', 'immagini/altro/logoverde.svg','template/logo-mobile.svg','template/favicon.ico', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;   ', 'font-family:\'Roboto\', sans-serif;    ', '#00a86b', '#6bbf59', '#4cb944', '#095256', '#f6f8ff', '#073b3a', '#f6ae2d', '#ed1c24', '#17af78', '#78c468', '#5cbf55', '#1f6165', '#fefeff', '#1d4c4b', '#f6b540', '#ee3037', '#009962', '#62ae51', '#46a93e', '#094b4f', '#ebebeb', '#073635', '#e09f29', '#d81a21', '576px','768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (3, 'Monocromo Rosso', 'Stai usando la configurazione Monocromo Rosso, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no','no', 'immagini/altro/logorosso.svg','template/logo-mobile.svg','template/favicon.ico', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;    ', 'font-family:\'Roboto\', sans-serif;     ', '#ff0800', '#a31621', '#4cb944', '#1f7a8c', '#fdfffc', '#020100', '#ffba08', '#ed1c24', '#ff1e17', '#ab2b35', '#5cbf55', '#338696', '#fefeff', '#191817', '#ffc01e', '#ee3037', '#e80800', '#95141e', '#46a93e', '#1d6f80', '#ebebeb', '#010100', '#e8aa08', '#d81a21', '576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (4, 'Monocromo Nero', 'Stai usando la configurazione Monocromo Nero, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no','no', 'immagini/altro/logonero.svg','template/logo-mobile.svg','template/favicon.ico', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;     ', 'font-family:\'Roboto\', sans-serif;      ', '#000f08', '#637074', '#4cb944', '#90a9b7', '#fcfcfc', '#000000', '#f9c22e', '#f22b29', '#17241e', '#717d80', '#5cbf55', '#9ab0b9', '#ffffff', '#191817', '#f9c741', '#f33e3c', '#000022', '#5a666a', '#46a93e', '#839aa7', '#e7e8e7', '#000000', '#e3b12a', '#dc2826', '576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (5, 'Monocromo Blu', 'Stai usando la configurazione Monocromo Blu, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no','no', 'immagini/altro/logoblu.svg','template/logo-mobile.svg','template/favicon.ico', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;      ', 'font-family:\'Roboto\', sans-serif;       ', '#1034a6', '#052f5f', '#60992d', '#81a4cd', '#f0f1ee', '#0d1317', '#ffc857', '#d62839', '#2546ae', '#1b416d', '#6ea240', '#8cacd1', '#fcfcfb', '#23282c', '#ffcd66', '#d93b4b', '#0f3097', '#052b57', '#588c29', '#7696bb', '#e0e2db', '#0b1013', '#e8b650', '#c32534', '576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (6, 'Monocromo Giallo', 'Stai usando la configurazione Monocromo Giallo, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no', 'immagini/altro/logogiallo.svg','template/logo-mobile.svg','template/favicon.ico', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;', 'font-family:\'Roboto\', sans-serif;  ', '#ffa900', '#d84a05', '#4cb944', '#335c67', '#fcfcfb', '#220901', '#eecf6d', '#990033', '#ffb017', '#db5a1b', '#5cbf55', '#456a74', '#fefefe', '#361f18', '#efd37a', '#a21745', '#e89a00', '#c54405', '#46a93e', '#2f545e', '#e6e6e5', '#1f0901', '#d9bd64', '#8c002f', '576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (7, 'Monocromo Viola', 'Stai usando la configurazione Monocromo Viola, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no', 'immagini/altro/logoviola.svg','template/logo-mobile.svg','template/favicon.ico', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', serif;  ', 'font-family:\'Roboto\', sans-serif;  ', '#6457a6', '#afa2ff', '#679436', '#cfb3cd', '#f2f6fb', '#0c0f0a', '#ffe347', '#990033', '#7266ae', '#b6aaff', '#749d48', '#d3b9d1', '#f5f9fc', '#222420', '#ffe557', '#a21745', '#5b5097', '#a094e8', '#5e8732', '#bda3bb', '#d6dce4', '#0b0e0a', '#e8cf41', '#8c002f', '576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (8, 'Monocromo Arancio', 'Stai usando la configurazione Monocromo Arancio, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no', 'immagini/altro/logoarancio.svg','template/logo-mobile.svg','template/favicon.ico', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif; ', 'font-family:\'Roboto\', sans-serif;   ', '#ff4f00', '#ff9505', '#9bc53d', '#197278', '#fffffc', '#000000', '#f7cb15', '#a30000', '#ff5f17', '#ff9e1b', '#a4ca4e', '#2d7e84', '#ffffff', '#000000', '#f7cf2a', '#ab1717', '#e84800', '#e88805', '#8db438', '#17686e', '#e8e8e6', '#000000', '#e1b914', '#950000', '576px','768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link'),
        (9, 'Monocromo Acqua', 'Stai usando la configurazione Monocromo Acqua, una delle configurazioni fornite al momento dell\'instalazione', 'no', 'no', 'no', 'immagini/altro/logoacqua.svg','template/logo-mobile.svg','template/favicon.ico', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap', 'font-family:\'Raleway\', sans-serif;  ', 'font-family:\'Roboto\', sans-serif;    ', '#1ca9c9', '#086788', '#3ec300', '#4e4d5c', '#fff9ed', '#011627', '#f0c808', '#dd1c1a', '#30b0cd', '#086788', '#4fc817', '#5e5d6a', '#fffdfa', '#182b3a', '#f1cd1e', '#e0302e', '#1a9ab7', '#075570', '#39b200', '#40404c', '#e8dcbe', '#011424', '#dbb608', '#c91a18', '576px','768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link')";

    //query per creare la tabella dei profili social
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_profiliSocial` (
            `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
            `facebook` VARCHAR( 255 ) NOT NULL ,
            `instagram` VARCHAR( 255 ) NOT NULL ,
            `youtube` VARCHAR( 255 ) NOT NULL ,
            `patreon` VARCHAR( 255 ) NOT NULL ,
            `ticToc` VARCHAR( 255 ) NOT NULL ,
            `linkedin` VARCHAR( 255 ) NOT NULL ,
            `twitter` VARCHAR( 255 ) NOT NULL ,
            `whatsapp` VARCHAR( 255 ) NOT NULL ,
            `mostraChatWhatsapp` VARCHAR( 55 ) NOT NULL ,
            `telegram` VARCHAR( 255 ) NOT NULL ,
            `mostraChatTelegram` VARCHAR( 55 ) NOT NULL ,
            PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella contenente le sezioni a due colonne
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_sezioniADueColonne` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `proporzioni` VARCHAR( 255 ) DEFAULT 'col-md-6, col-md-6',
        `allineamento` VARCHAR(255) DEFAULT 'd-flex align-items-start',
        `idComponenteSezione1` INT( 11 ) DEFAULT 0 ,
        `idElementoSezione1` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione2` INT( 11 ) DEFAULT 0 ,
        `idElementoSezione2` INT( 11 ) DEFAULT 0 ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella contenente le sezioni a tre colonne
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_sezioniATreColonne` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `proporzioni` VARCHAR( 255 ) DEFAULT 'col-md-4, col-md-4, col-md-4',
        `allineamento` VARCHAR(255) DEFAULT 'd-flex align-items-start',
        `idComponenteSezione1` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione2` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione3` INT( 11 ) DEFAULT 0 ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //imposta il valore iniziale dell'id a 500, serve per evitare che in una pagina ci siano sezioni a due colonne, tre colonne o quattro colonne con lo stesso id
    $queryTabelleComuni[count($queryTabelleComuni)]  = "ALTER TABLE `geec_sezioniATreColonne` AUTO_INCREMENT=250;";
    
    //query per creare la tabella contenente le sezioni a quattro colonne
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_sezioniAQuattroColonne` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `proporzioni` VARCHAR( 255 ) DEFAULT 'col-md-6, col-md-6',
        `allineamento` VARCHAR(255) DEFAULT 'd-flex align-items-start',
        `idComponenteSezione1` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione2` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione3` INT( 11 ) DEFAULT 0 ,
        `idComponenteSezione4` INT( 11 ) DEFAULT 0 ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //imposta il valore iniziale dell'id a 500, serve per evitare che in una pagina ci siano sezioni a due colonne, tre colonne o quattro colonne con lo stesso id
    $queryTabelleComuni[count($queryTabelleComuni)]  = "ALTER TABLE `geec_sezioniAQuattroColonne` AUTO_INCREMENT=500;";
    
    //query per creare la tabella dei gruppi
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_gruppi` (
            `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
            `nome` VARCHAR( 255 ) NOT NULL ,
            `tipo` VARCHAR( 255 ) NOT NULL ,
            `descrizione` VARCHAR( 255 ) NOT NULL,
            `dataCreazione` DATE NOT NULL,
            PRIMARY KEY ( `id` )
            ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella che associa i gruppi agli utenti
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_gruppiUtenti` (
        `idGruppoUtente` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `idUtente` INT( 11 ) NOT NULL ,
        `idGruppo` INT( 11 ) NOT NULL ,
        PRIMARY KEY ( `idGruppoUtente` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella categorie
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_categorie` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `categoriaMadre` INT( 11 ) NOT NULL,
        `categoriaRiferimento` INT( 11 ) NOT NULL,
        `tipo` VARCHAR( 55 ) NOT NULL ,
        `lingua` VARCHAR( 55 ) NOT NULL ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `alias` VARCHAR( 255 ) NOT NULL ,
        `titoloPagina` VARCHAR( 255 ) NOT NULL ,
        `metaDescrizione` VARCHAR( 255 ) NOT NULL ,
        `cssGenerato` TEXT( 65000 ) NOT NULL ,
        `cssAggiuntivo` TEXT( 65000 ) NOT NULL ,
        `foto` VARCHAR( 255 ) NOT NULL ,
        `punteggioSeo` VARCHAR( 255 ) NOT NULL ,
        `tipoVisualizzazione` VARCHAR( 255 ) NOT NULL ,
        `numeroArticoliPerPagina` INT( 11 ),
        `posizione` SMALLINT( 6 ),
        `ordinamento` VARCHAR( 255 ),
        `dataCreazione` DATE NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    // query per creare la tabella statistiche, che contiene sia pagine che gallerie
    // gallerie lascerà alcuni campi vuoti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecAd_statistiche` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `numeroLogin` INT( 11 ) NOT NULL ,
        `loginOggi` INT( 11 ) NOT NULL ,
        `dataUltimoLogin` DATE NOT NULL ,
        `dataInstallazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    //query per creare la tabella che associa le categorie ai contenuti
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_associazioneCategorieContenuti` (
        `idCategoria` INT( 11 ) NOT NULL ,
        `idContenuto` INT( 11 ) NOT NULL ,
        `tipoContenuto` VARCHAR( 255 ) NOT NULL
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_reindirizzamenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `urlDaReindirizzare` VARCHAR( 255 ) NOT NULL ,
        `nuovoIndirizzo` VARCHAR( 255 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";    
    
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_prodotti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `installato` VARCHAR( 255 ) NOT NULL ,
        `versione` VARCHAR( 255 ) NOT NULL,
        `percorso` VARCHAR( 255 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    // query per inserire i prodotti Geecom
    $queryTabelleComuni[count($queryTabelleComuni)] = "INSERT INTO geec_prodotti (`id`,`nome`,`installato`,`versione`,`percorso`) VALUES
        (NULL,'CMS','no','',''),
        (NULL,'Admin','si','{$infoGeecom["versione"]}','$cartellaAmministrazione'),
        (NULL,'Doc','no','','');";
    
    /*
     * Tabella per memorizzare lo storico delle azioni svolte sui prodotti Geecom. 
     * Ogni elemento deve contenere
     *  - prodotto (Cms, Admin, Ask ecc)
     *  - tipo (notificaUtente o notificaAmministratore)
     *  idUtente (0 se si tratta di una notifica per amministratori)
     *  testo
     *  letta (vale si se è stata letta, altrimenti vale no)
     */ 
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_elementoStoricoOperazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `prodotto` VARCHAR (255) NOT NULL ,
        `tipo` VARCHAR (255) NOT NULL,
        `testo` TEXT (65000) NOT NULL,
        `dataCreazione` DATETIME NOT NULL ,
        PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_impostazioniApp` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `attivaApp` VARCHAR (255) NOT NULL,
        `nomeCompleto` VARCHAR (255) NOT NULL,
        `nomeAbbreviato` VARCHAR (255) NOT NULL,
        `icona48` VARCHAR (255) NOT NULL,
        `icona96` VARCHAR (255) NOT NULL,
        `icona144` VARCHAR (255) NOT NULL,
        `icona192` VARCHAR (255) NOT NULL,
        `icona512` VARCHAR (255) NOT NULL,
        `colore` VARCHAR (255) NOT NULL,
        PRIMARY KEY ( `id` )
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare i moduli di contatto
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_form` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR( 55 ) DEFAULT 'col-12' ,
        `tipoConfermaMessaggioInviato` VARCHAR( 255 ) DEFAULT 'Messaggio a video' ,        
        `emailNotificaAmministratore` VARCHAR( 255 ) DEFAULT '' ,
        `rispondiA` VARCHAR( 255 ) DEFAULT '' ,
        `oggettoNotificaAmministratore` VARCHAR( 255 ) DEFAULT 'Nuovo messaggio dal tuo sito $nomePiattaforma' ,
        `testoMessaggioInviato` VARCHAR( 255 ) DEFAULT 'Grazie! Ti contatteremo quanto prima' ,
        `testoMessaggioErrore` VARCHAR( 255 ) DEFAULT '' ,
        `paginaRingraziamento` INT( 11 ) DEFAULT 0 ,
        `formInLinea` VARCHAR( 55 ) DEFAULT 'col-12' ,
        `testo` TEXT( 65000 ) ,
        `stampaLinkPaginaForm` VARCHAR( 55 ) DEFAULT 'no' ,
        `spuntaPrivacy` VARCHAR( 55 ) DEFAULT 'si' ,
        `linkPrivacy` VARCHAR( 255 ) DEFAULT 'index.php?alias=informativa-sulla-privacy' ,
        `azione` VARCHAR( 255 ) DEFAULT 'Invia email' ,
        `etichettaPulsante` VARCHAR( 255 ) DEFAULT 'Invia' ,
        `iconaPulsante` VARCHAR( 255 ) DEFAULT 'fas fa-paper-plane' ,
        `spazioOccupatoPulsante` VARCHAR( 255 ) DEFAULT '' ,
        `linkScriptEsterno` VARCHAR( 255 ) DEFAULT '' ,
        `linkScriptRicerca` VARCHAR( 255 ) DEFAULT '' ,    
        `usaAjax` VARCHAR( 55 ) DEFAULT 'no' ,
        `noteAggiuntive` VARCHAR( 255 ) DEFAULT '* campo obbligatorio',
        `contatoreInvii` INT( 11 ) DEFAULT 0 ,
        `attivaNotificaUtente` VARCHAR( 55 ) DEFAULT '' ,
        `campoEmailNotificaUtente` VARCHAR( 255 ) DEFAULT '' ,
        `nomeMittenteNotificaUtente` VARCHAR( 255 ) DEFAULT '' ,
        `emailMittenteNotificaUtente` VARCHAR( 255 ) DEFAULT '' ,
        `oggettoNotificaUtente` VARCHAR( 255 ) DEFAULT '' ,
        `templateEmailNotificaUtente` INT( 11 ) DEFAULT 0 ,
        `mostraTitoloComponente` VARCHAR( 55 ) DEFAULT 'si' ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";

    /*
     * query creazione tabella per memorizzare i messaggi inviati tramite form
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_messaggiForm` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idForm` INT( 11 ) NOT NULL,
        `testo` TEXT( 1000 ) NOT NULL ,
        `dataCreazione` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare gli elementi presenti in ogni modulo di contatto
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_elementiForm` (
        `id` INT(11) NOT NULL AUTO_INCREMENT,
        `idForm` INT(11) NOT NULL,
        `posizione` tinyINT(4) NOT NULL,
        `spazioOccupato` VARCHAR( 55 ) NOT NULL,
        `nome` varchar(255) NOT NULL,
        `etichetta` varchar(255) NOT NULL,
        `valore` varchar(255) NOT NULL,
        `placeholder` varchar(255) NOT NULL,
        `tipo` varchar(255) NOT NULL,
        `opzioni` varchar(255) NOT NULL,
        `obbligatorio` varchar(255) NOT NULL,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    
    /*
     * query creazione tabella per memorizzare i video
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_video` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT ,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `spazioOccupato` VARCHAR( 55 ) DEFAULT 'col-12' ,
        `stile` VARCHAR( 55 ) DEFAULT 'Solo video' ,
        `animazioneVideo` VARCHAR( 55 ) DEFAULT '' ,
        `animazioneTesto` VARCHAR( 55 ) DEFAULT '' ,
        `video` TEXT( 5000 ) ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query creazione tabella per i visualizzatori di risorse
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_visualizzatoriRisorse` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL,
        `categoria` INT( 11 ) DEFAULT 0,
        `descrizione` VARCHAR( 255 ) DEFAULT '',
        `filtrabile` VARCHAR( 255 ) DEFAULT 'no',
        `aTuttaLarghezza` VARCHAR( 255 ) DEFAULT 'no',
        `senzaBordi` VARCHAR( 255 ) DEFAULT 'no',
        `classeElementi` VARCHAR( 255 ) DEFAULT 'portfolio col-sm-6 col-md-4',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_templateEmail` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR (255) NOT NULL ,
        `css` TEXT (65000) NOT NULL ,
        `corpoMail` TEXT (65000) NOT NULL ,
        `footerMail` TEXT (65000) NOT NULL ,
        PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * query per creare la tabella delle immagini
     * il campo tipoImmagine 
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_immagini` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idContenuto` INT( 11 ) NOT NULL,
        `tipoImmagine` VARCHAR( 255 ) NOT NULL ,
        `percorso` VARCHAR( 255 ) NOT NULL ,
        `descrizione` VARCHAR( 255 ) NOT NULL ,
        `posizione` TINYINT NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    /*
     * Tabella per l'immagazzinamento delle notifiche. Ogni notifica deve contenere
     *  - prodotto (Cms, Admin, Ask ecc)
     *  - tipo (notificaUtente o notificaAmministratore)
     *  idUtente (0 se si tratta di una notifica per amministratori)
     *  testo
     *  letta (vale si se è stata letta, altrimenti vale no)
     */ 
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE `geec_notifiche` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `prodotto` VARCHAR (255) NOT NULL ,
        `tipo` VARCHAR (255) NOT NULL,
        `idUtente` INT( 11 ) NOT NULL,
        `testo` TEXT (65000) NOT NULL,
        `link` VARCHAR (255) NOT NULL,
        `letta` VARCHAR (55) NOT NULL,
        `dataCreazione` DATETIME NOT NULL ,
        PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
        
    $queryTabelleComuni[count($queryTabelleComuni)] = "INSERT INTO `geec_impostazioniApp` (`id`, `attivaApp`, `nomeCompleto`, `nomeAbbreviato`, `icona48`, `icona96`, `icona144`, `icona192`, `icona512`, `colore`) "
                                                    . "VALUES (NULL, 'no', '$nomePiattaforma', '', 'immagini/altro/Geecom-icona-48.png', 'immagini/altro/Geecom-icona-96.png', 'immagini/altro/Geecom-icona-144.png', 'immagini/altro/Geecom-icona-192.png', 'immagini/altro/Geecom-icona-512.png', '');";
    
    /*
     *  il template sorgente è un tema
     */
    $queryTabelleComuni[count($queryTabelleComuni)] = "INSERT INTO `geec_templateEmail` (`id`, `nome`, `css`, `corpoMail`, `footerMail`) VALUES
                                                        (NULL, 'Template sorgente', '      /* -------------------------------------\r\n          GLOBAL RESETS\r\n      ------------------------------------- */\r\n      \r\n      /* Classi personalizzate da aggiungere qui*/\r\n      \r\n      img {\r\n        border: none;\r\n        -ms-interpolation-mode: bicubic;\r\n        max-width: 100%; \r\n      }\r\n\r\n      body {\r\n        background-color: #f6f6f6;\r\n        font-family: sans-serif;\r\n        -webkit-font-smoothing: antialiased;\r\n        font-size: 14px;\r\n        line-height: 1.4;\r\n        margin: 0;\r\n        padding: 0;\r\n        -ms-text-size-adjust: 100%;\r\n        -webkit-text-size-adjust: 100%; \r\n      }\r\n\r\n      table {\r\n        border-collapse: separate;\r\n        mso-table-lspace: 0pt;\r\n        mso-table-rspace: 0pt;\r\n        width: 100%; }\r\n        table td {\r\n          font-family: sans-serif;\r\n          font-size: 14px;\r\n          vertical-align: top; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          BODY E CONTAINER\r\n      ------------------------------------- */\r\n\r\n      .body {\r\n        background-color: #f6f6f6;\r\n        width: 100%; \r\n      }\r\n\r\n      .container {\r\n        display: block;\r\n        margin: 0 auto !important;\r\n        max-width: 580px;\r\n        padding: 10px;\r\n        width: 580px; \r\n      }\r\n\r\n      .content {\r\n        box-sizing: border-box;\r\n        display: block;\r\n        margin: 0 auto;\r\n        max-width: 580px;\r\n        padding: 10px; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          HEADER, FOOTER, MAIN\r\n      ------------------------------------- */\r\n      .main {\r\n        background: #ffffff;\r\n        border-radius: 3px;\r\n        width: 100%; \r\n      }\r\n\r\n      .wrapper {\r\n        box-sizing: border-box;\r\n        padding: 20px; \r\n      }\r\n\r\n      .content-block {\r\n        padding-bottom: 10px;\r\n        padding-top: 10px;\r\n      }\r\n\r\n      .footer {\r\n        clear: both;\r\n        margin-top: 10px;\r\n        text-align: center;\r\n        width: 100%; \r\n      }\r\n        .footer td,\r\n        .footer p,\r\n        .footer span,\r\n        .footer a {\r\n          color: #999999;\r\n          font-size: 12px;\r\n          text-align: center; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          TIPOGRAFIA E LETTERING\r\n      ------------------------------------- */\r\n      h1,\r\n      h2,\r\n      h3,\r\n      h4 {\r\n        color: #000000;\r\n        font-family: sans-serif;\r\n        font-weight: 400;\r\n        line-height: 1.4;\r\n        margin: 0;\r\n        margin-bottom: 30px; \r\n      }\r\n\r\n      h1 {\r\n        font-size: 35px;\r\n        font-weight: 300;\r\n        text-align: center;\r\n        text-transform: capitalize; \r\n      }\r\n\r\n      p,\r\n      ul,\r\n      ol {\r\n        font-family: sans-serif;\r\n        font-size: 14px;\r\n        font-weight: normal;\r\n        margin: 0;\r\n        margin-bottom: 15px; \r\n      }\r\n        p li,\r\n        ul li,\r\n        ol li {\r\n          list-style-position: inside;\r\n          margin-left: 5px; \r\n      }\r\n\r\n      a {\r\n        color: #018394;\r\n        text-decoration: underline; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          PULSANTI\r\n      ------------------------------------- */\r\n      .btn {\r\n        box-sizing: border-box;\r\n        width: 100%; }\r\n        .btn > tbody > tr > td {\r\n          padding-bottom: 15px; }\r\n        .btn table {\r\n          width: auto; \r\n      }\r\n        .btn table td {\r\n          background-color: #ffffff;\r\n          border-radius: 5px;\r\n          text-align: center; \r\n      }\r\n        .btn a {\r\n          background-color: #ffffff;\r\n          border: solid 1px #018394;\r\n          border-radius: 5px;\r\n          box-sizing: border-box;\r\n          color: #018394;\r\n          cursor: pointer;\r\n          display: inline-block;\r\n          font-size: 14px;\r\n          font-weight: bold;\r\n          margin: 0;\r\n          padding: 12px 25px;\r\n          text-decoration: none;\r\n          text-transform: capitalize; \r\n      }\r\n\r\n      .btn-primary table td {\r\n        background-color: #018394; \r\n      }\r\n\r\n      .btn-primary a {\r\n        background-color: #018394;\r\n        border-color: #018394;\r\n        color: #ffffff; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          ALTRI STILI UTILI\r\n      ------------------------------------- */\r\n      .last {\r\n        margin-bottom: 0; \r\n      }\r\n\r\n      .first {\r\n        margin-top: 0; \r\n      }\r\n\r\n      .align-center {\r\n        text-align: center; \r\n      }\r\n\r\n      .align-right {\r\n        text-align: right; \r\n      }\r\n\r\n      .align-left {\r\n        text-align: left; \r\n      }\r\n\r\n      .clear {\r\n        clear: both; \r\n      }\r\n\r\n      .mt0 {\r\n        margin-top: 0; \r\n      }\r\n\r\n      .mb0 {\r\n        margin-bottom: 0; \r\n      }\r\n\r\n      .preheader {\r\n        color: transparent;\r\n        display: none;\r\n        height: 0;\r\n        max-height: 0;\r\n        max-width: 0;\r\n        opacity: 0;\r\n        overflow: hidden;\r\n        mso-hide: all;\r\n        visibility: hidden;\r\n        width: 0; \r\n      }\r\n\r\n      .powered-by a {\r\n        text-decoration: none; \r\n      }\r\n\r\n      hr {\r\n        border: 0;\r\n        border-bottom: 1px solid #f6f6f6;\r\n        margin: 20px 0; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          STILI RESPONSIVE E MOBILE FRIENDLY \r\n      ------------------------------------- */\r\n      @media only screen and (max-width: 620px) {\r\n        table[class=body] h1 {\r\n          font-size: 28px !important;\r\n          margin-bottom: 10px !important; \r\n        }\r\n        table[class=body] p,\r\n        table[class=body] ul,\r\n        table[class=body] ol,\r\n        table[class=body] td,\r\n        table[class=body] span,\r\n        table[class=body] a {\r\n          font-size: 16px !important; \r\n        }\r\n        table[class=body] .wrapper,\r\n        table[class=body] .article {\r\n          padding: 10px !important; \r\n        }\r\n        table[class=body] .content {\r\n          padding: 0 !important; \r\n        }\r\n        table[class=body] .container {\r\n          padding: 0 !important;\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .main {\r\n          border-left-width: 0 !important;\r\n          border-radius: 0 !important;\r\n          border-right-width: 0 !important; \r\n        }\r\n        table[class=body] .btn table {\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .btn a {\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .img-responsive {\r\n          height: auto !important;\r\n          max-width: 100% !important;\r\n          width: auto !important; \r\n        }\r\n      }\r\n\r\n      /* -------------------------------------\r\n          PRESERVA STILI HEAD\r\n      ------------------------------------- */\r\n      @media all {\r\n        .ExternalClass {\r\n          width: 100%; \r\n        }\r\n        .ExternalClass,\r\n        .ExternalClass p,\r\n        .ExternalClass span,\r\n        .ExternalClass font,\r\n        .ExternalClass td,\r\n        .ExternalClass div {\r\n          line-height: 100%; \r\n        }\r\n        .apple-link a {\r\n          color: inherit !important;\r\n          font-family: inherit !important;\r\n          font-size: inherit !important;\r\n          font-weight: inherit !important;\r\n          line-height: inherit !important;\r\n          text-decoration: none !important; \r\n        }\r\n        #MessageViewBody a {\r\n          color: inherit;\r\n          text-decoration: none;\r\n          font-size: inherit;\r\n          font-family: inherit;\r\n          font-weight: inherit;\r\n          line-height: inherit;\r\n        }\r\n        .btn-primary table td:hover {\r\n          background-color: #016c7a !important; \r\n        }\r\n        .btn-primary a:hover {\r\n          background-color: #016c7a !important;\r\n          border-color: #016c7a !important; \r\n        } \r\n      }', '<table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"body\">\r\n      <tr>\r\n        <td> </td>\r\n        <td class=\"container\">\r\n          <div class=\"content\">\r\n\r\n            <!-- START CONTAINER BIANCO CENTRATO -->\r\n            <table role=\"presentation\" class=\"main\">\r\n\r\n              <!-- START AREA MAIN CONTENT -->\r\n              <tr>\r\n                <td class=\"wrapper\">\r\n                  <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n				__intestazione_mail__\r\n				<tr>\r\n				  	<td> </td>\r\n				</tr>\r\n                    <tr>\r\n                      <td>\r\n				testo_da_inserire\r\n                      </td>\r\n                    </tr>\r\n                  </table>\r\n                </td>\r\n              </tr>\r\n\r\n            <!-- FINE AEREA MAIN CONTENT -->\r\n            </table>\r\n            <!-- FINE CONTAINE BIANCO CENTRATO -->', '            <!-- START FOOTER -->\r\n            <div class=\"footer\">\r\n              <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                <tr>\r\n                  <td class=\"content-block\">\r\n                    <br> Non vuoi piu ricevere questa mail? <a href=\"#\">Clicca qui</a>.\r\n                  </td>\r\n                </tr>\r\n                <tr>\r\n                  <td class=\"content-block powered-by\">\r\n                    Powered by <a href=\"#\">Geecom</a>.\r\n                  </td>\r\n                </tr>\r\n              </table>\r\n            </div>\r\n            <!-- FINE FOOTER -->'),
                                                        (NULL, 'Template base', '      /* -------------------------------------\r\n          GLOBAL RESETS\r\n      ------------------------------------- */\r\n      \r\n      /* Classi personalizzate da aggiungere qui*/\r\n      \r\n      img {\r\n        border: none;\r\n        -ms-interpolation-mode: bicubic;\r\n        max-width: 100%; \r\n      }\r\n\r\n      body {\r\n        background-color: #f6f6f6;\r\n        font-family: sans-serif;\r\n        -webkit-font-smoothing: antialiased;\r\n        font-size: 14px;\r\n        line-height: 1.4;\r\n        margin: 0;\r\n        padding: 0;\r\n        -ms-text-size-adjust: 100%;\r\n        -webkit-text-size-adjust: 100%; \r\n      }\r\n\r\n      table {\r\n        border-collapse: separate;\r\n        mso-table-lspace: 0pt;\r\n        mso-table-rspace: 0pt;\r\n        width: 100%; }\r\n        table td {\r\n          font-family: sans-serif;\r\n          font-size: 14px;\r\n          vertical-align: top; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          BODY E CONTAINER\r\n      ------------------------------------- */\r\n\r\n      .body {\r\n        background-color: #f6f6f6;\r\n        width: 100%; \r\n      }\r\n\r\n      .container {\r\n        display: block;\r\n        margin: 0 auto !important;\r\n        max-width: 580px;\r\n        padding: 10px;\r\n        width: 580px; \r\n      }\r\n\r\n      .content {\r\n        box-sizing: border-box;\r\n        display: block;\r\n        margin: 0 auto;\r\n        max-width: 580px;\r\n        padding: 10px; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          HEADER, FOOTER, MAIN\r\n      ------------------------------------- */\r\n      .main {\r\n        background: #ffffff;\r\n        border-radius: 3px;\r\n        width: 100%; \r\n      }\r\n\r\n      .wrapper {\r\n        box-sizing: border-box;\r\n        padding: 20px; \r\n      }\r\n\r\n      .content-block {\r\n        padding-bottom: 10px;\r\n        padding-top: 10px;\r\n      }\r\n\r\n      .footer {\r\n        clear: both;\r\n        margin-top: 10px;\r\n        text-align: center;\r\n        width: 100%; \r\n      }\r\n        .footer td,\r\n        .footer p,\r\n        .footer span,\r\n        .footer a {\r\n          color: #999999;\r\n          font-size: 12px;\r\n          text-align: center; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          TIPOGRAFIA E LETTERING\r\n      ------------------------------------- */\r\n      h1,\r\n      h2,\r\n      h3,\r\n      h4 {\r\n        color: #000000;\r\n        font-family: sans-serif;\r\n        font-weight: 400;\r\n        line-height: 1.4;\r\n        margin: 0;\r\n        margin-bottom: 30px; \r\n      }\r\n\r\n      h1 {\r\n        font-size: 35px;\r\n        font-weight: 300;\r\n        text-align: center;\r\n        text-transform: capitalize; \r\n      }\r\n\r\n      p,\r\n      ul,\r\n      ol {\r\n        font-family: sans-serif;\r\n        font-size: 14px;\r\n        font-weight: normal;\r\n        margin: 0;\r\n        margin-bottom: 15px; \r\n      }\r\n        p li,\r\n        ul li,\r\n        ol li {\r\n          list-style-position: inside;\r\n          margin-left: 5px; \r\n      }\r\n\r\n      a {\r\n        color: #018394;\r\n        text-decoration: underline; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          PULSANTI\r\n      ------------------------------------- */\r\n      .btn {\r\n        box-sizing: border-box;\r\n        width: 100%; }\r\n        .btn > tbody > tr > td {\r\n          padding-bottom: 15px; }\r\n        .btn table {\r\n          width: auto; \r\n      }\r\n        .btn table td {\r\n          background-color: #ffffff;\r\n          border-radius: 5px;\r\n          text-align: center; \r\n      }\r\n        .btn a {\r\n          background-color: #ffffff;\r\n          border: solid 1px #018394;\r\n          border-radius: 5px;\r\n          box-sizing: border-box;\r\n          color: #018394;\r\n          cursor: pointer;\r\n          display: inline-block;\r\n          font-size: 14px;\r\n          font-weight: bold;\r\n          margin: 0;\r\n          padding: 12px 25px;\r\n          text-decoration: none;\r\n          text-transform: capitalize; \r\n      }\r\n\r\n      .btn-primary table td {\r\n        background-color: #018394; \r\n      }\r\n\r\n      .btn-primary a {\r\n        background-color: #018394;\r\n        border-color: #018394;\r\n        color: #ffffff; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          ALTRI STILI UTILI\r\n      ------------------------------------- */\r\n      .last {\r\n        margin-bottom: 0; \r\n      }\r\n\r\n      .first {\r\n        margin-top: 0; \r\n      }\r\n\r\n      .align-center {\r\n        text-align: center; \r\n      }\r\n\r\n      .align-right {\r\n        text-align: right; \r\n      }\r\n\r\n      .align-left {\r\n        text-align: left; \r\n      }\r\n\r\n      .clear {\r\n        clear: both; \r\n      }\r\n\r\n      .mt0 {\r\n        margin-top: 0; \r\n      }\r\n\r\n      .mb0 {\r\n        margin-bottom: 0; \r\n      }\r\n\r\n      .preheader {\r\n        color: transparent;\r\n        display: none;\r\n        height: 0;\r\n        max-height: 0;\r\n        max-width: 0;\r\n        opacity: 0;\r\n        overflow: hidden;\r\n        mso-hide: all;\r\n        visibility: hidden;\r\n        width: 0; \r\n      }\r\n\r\n      .powered-by a {\r\n        text-decoration: none; \r\n      }\r\n\r\n      hr {\r\n        border: 0;\r\n        border-bottom: 1px solid #f6f6f6;\r\n        margin: 20px 0; \r\n      }\r\n\r\n      /* -------------------------------------\r\n          STILI RESPONSIVE E MOBILE FRIENDLY \r\n      ------------------------------------- */\r\n      @media only screen and (max-width: 620px) {\r\n        table[class=body] h1 {\r\n          font-size: 28px !important;\r\n          margin-bottom: 10px !important; \r\n        }\r\n        table[class=body] p,\r\n        table[class=body] ul,\r\n        table[class=body] ol,\r\n        table[class=body] td,\r\n        table[class=body] span,\r\n        table[class=body] a {\r\n          font-size: 16px !important; \r\n        }\r\n        table[class=body] .wrapper,\r\n        table[class=body] .article {\r\n          padding: 10px !important; \r\n        }\r\n        table[class=body] .content {\r\n          padding: 0 !important; \r\n        }\r\n        table[class=body] .container {\r\n          padding: 0 !important;\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .main {\r\n          border-left-width: 0 !important;\r\n          border-radius: 0 !important;\r\n          border-right-width: 0 !important; \r\n        }\r\n        table[class=body] .btn table {\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .btn a {\r\n          width: 100% !important; \r\n        }\r\n        table[class=body] .img-responsive {\r\n          height: auto !important;\r\n          max-width: 100% !important;\r\n          width: auto !important; \r\n        }\r\n      }\r\n\r\n      /* -------------------------------------\r\n          PRESERVA STILI HEAD\r\n      ------------------------------------- */\r\n      @media all {\r\n        .ExternalClass {\r\n          width: 100%; \r\n        }\r\n        .ExternalClass,\r\n        .ExternalClass p,\r\n        .ExternalClass span,\r\n        .ExternalClass font,\r\n        .ExternalClass td,\r\n        .ExternalClass div {\r\n          line-height: 100%; \r\n        }\r\n        .apple-link a {\r\n          color: inherit !important;\r\n          font-family: inherit !important;\r\n          font-size: inherit !important;\r\n          font-weight: inherit !important;\r\n          line-height: inherit !important;\r\n          text-decoration: none !important; \r\n        }\r\n        #MessageViewBody a {\r\n          color: inherit;\r\n          text-decoration: none;\r\n          font-size: inherit;\r\n          font-family: inherit;\r\n          font-weight: inherit;\r\n          line-height: inherit;\r\n        }\r\n        .btn-primary table td:hover {\r\n          background-color: #016c7a !important; \r\n        }\r\n        .btn-primary a:hover {\r\n          background-color: #016c7a !important;\r\n          border-color: #016c7a !important; \r\n        } \r\n      }', '<table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"body\">\r\n      <tr>\r\n        <td>&nbsp;</td>\r\n        <td class=\"container\">\r\n          <div class=\"content\">\r\n\r\n            <!-- START CONTAINER BIANCO CENTRATO -->\r\n            <table role=\"presentation\" class=\"main\">\r\n\r\n              <!-- START AREA MAIN CONTENT -->\r\n              <tr>\r\n                <td class=\"wrapper\">\r\n                  <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n					<tr>\r\n					  	<td align=\"center\">\r\n							<img src=\"$urlPiattaforma/immagini/immaginiDiSistema/logo_Geecom.jpg\" alt=\"Nome sito\" width=\"220\" height=\"65\" border=\"0\" style=\"border:0; outline:none; text-decoration:none; display:block;\">  \r\n						</td>\r\n					</tr>\r\n					  <tr>\r\n					  	<td>&nbsp;</td>\r\n					  </tr>\r\n                    <tr>\r\n                      <td>\r\n				testo_da_inserire\r\n                      </td>\r\n                    </tr>\r\n                  </table>\r\n                </td>\r\n              </tr>\r\n\r\n            <!-- FINE AEREA MAIN CONTENT -->\r\n            </table>\r\n            <!-- FINE CONTAINE BIANCO CENTRATO -->', '            <!-- START FOOTER -->\r\n            <div class=\"footer\">\r\n              <table role=\"presentation\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n                <tr>\r\n                  <td class=\"content-block\">\r\n\r\n                    <br> Non vuoi piu ricevere questa mail? <a href=\"#\">Clicca qui</a>.\r\n                  </td>\r\n                </tr>\r\n                <tr>\r\n                  <td class=\"content-block powered-by\">\r\n                    Powered by <a href=\"#\">Geecom</a>.\r\n                  </td>\r\n                </tr>\r\n              </table>\r\n            </div>\r\n            <!-- FINE FOOTER -->'),
                                                        (NULL, 'Template vuoto', '', 'testo_da_inserire', '');";
    
    //query per creare la tabella contenente i dati per gli input esterni
    $queryTabelleComuni[count($queryTabelleComuni)] = "CREATE TABLE IF NOT EXISTS `geec_inputEsterni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `attivo` VARCHAR( 55 ) NOT NULL,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `tipoRichiesta` VARCHAR( 55 ) NOT NULL,
        `parametroIdentificativo` VARCHAR( 255 ) NOT NULL ,
        `valoreParametro` VARCHAR( 255 ) NOT NULL ,
        `azione` VARCHAR( 255 ) NOT NULL ,
        `linkDestinazione` VARCHAR( 255 ) NOT NULL ,
        `numeroChiamate` INT( 11 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8mb4;";
    
    $data = date("Y-m-d H:i");

    // 	QUERY DI CONFIGURAZIONE
    $queryDiConfigurazione = array();
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_moduliRegistrazione VALUES
        (NULL,'Modulo registrazione 1','no','no','no','no','no','no','no','no','no','no','no','no','no','La tua registrazione è stata effettuata con successo<br>Grazie!','si','$email');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geec_profiliSocial VALUES (NULL,'','','','','','','','','','','');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_componenti (`id`,`tipo`,`componenteArticolo`,`icona`,`nome`,`paginaGestione`,`tabellaRiferimento`,`script`) VALUES
        (NULL,'barraSuperiore','no','','Menu','','',''),
        (NULL,'barraSuperiore','no','','Menu scelta lingue','','',''),
        (NULL,'barraSuperiore','no','','Profili social','','',''),
        (NULL,'barraSuperiore','no','','Testo','','',''),
        (NULL,'barraSuperiore','no','','Modulo login','','',''),
        (NULL,'interno','no','','Articoli piu letti','','',''),
        (NULL,'interno','no','','Categorie','','',''),
        (NULL,'interno','no','','Tag','','',''),
        (NULL,'interno','no','','Form ricerca', '','',''),
        (NULL,'interno','no','','Banner laterale','','',''),
        (NULL,'interno','no','','Ultime risorse','','',''),
        (NULL,'interno','no','','Ultime gallerie','','',''),
        (NULL,'interno','no','','Ultimi articoli','','',''),
        (NULL,'interno','no','','HTML personalizzato','htmlPersonalizzato','',''),
        (NULL,'interno','no','','Categoria in evidenza','categoriaInEvidenza','',''),
        (NULL,'interno','no','','Menu laterale','menuLaterale','',''),
        (NULL,'interno','no','','Testo personalizzato','testoPersonalizzato','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_intestazione.svg','Intestazione','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_testo.svg','Testo','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_html.svg','HTML','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_immagine_a_tutta_larghezza.svg','Immagine','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_pulsante.svg','Pulsante','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_articolo_blog.svg','Articolo dal blog','','',''),
        (NULL,'componenteMail','no','../template/img/componenti/icon_prodotto_negozio.svg','Prodotto dal negozio','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_intestazione.svg','Intestazione','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_testo.svg','Testo','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_html.svg','Html','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_codice.svg','Includi codice', '','',''),
        (NULL,'componenteDinamico','si','../template/img/componenti/icon_immagine_a_tutta_larghezza.svg','Immagine','','',''),
        (NULL,'componenteDinamico','si','../template/img/componenti/icon_audio.svg','Audio','','',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_video.svg','Video', 'video','geec_video',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_form.svg','Form', 'form','geec_form',''),
        (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_risorse.svg','Risorse','visualizzatoreRisorse','geec_visualizzatoriRisorse',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_login.svg','Modulo login','','',''),
        (NULL,'componenteDinamico','no','../template/img/componenti/icon_registrazione.svg','Modulo registrazione','','',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_loginRegistrati.svg','Modulo login/registrati','','',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_recupero_password.svg','Modulo recupera password','','',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_notifiche.svg','Visualizzatore notifiche','','',''),
        (NULL,'componenteDinamicoNonConfigurabile','no','../template/img/componenti/icon_profilo.svg','Visualizzatore pagina profilo','','',''),
        (NULL,'componenteStrutturaPagina','no','../template/img/componenti/icon_sezione_2.svg','Sezione a due colonne','','geec_sezioniADueColonne',''),
        (NULL,'componenteStrutturaPagina','no','../template/img/componenti/icon_sezione_3.svg','Sezione a tre colonne','','geec_sezioniATreColonne',''),
        (NULL,'componenteStrutturaPagina','no','../template/img/componenti/icon_sezione_4.svg','Sezione a quattro colonne','','geec_sezioniAQuattroColonne',''),
        (NULL,'componenteDinamicoPagine','no','../template/img/componenti/icon_cruscotto.svg','Cruscotto','cruscotto','geec_cruscotti','');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_impostazioni` (`id`, `attivaHttps`, `logo`, `logoMobile`, `dimensioneAreaLogin`, `titoloAreaLogin`, `testoAreaLogin`, `menuSceltaLingue`, `attivaFortino`, `parolaChiaveFortino`, `tipoRedirectLogin` ,`linkPersonalizzatoLogin`, `paginaLogin`, `paginaLoginEn`, `paginaRegistrazione`, `paginaRegistrazioneEn`, `homePage`, `homePageEn`, `mostraProfilo`, `paginaProfilo`, `paginaProfiloEn`, `paginaRecuperoPassword`, `paginaRecuperoPasswordEn`, `paginaNotifiche`, `paginaNotificheEn`, `urlPiattaforma`, `nomePiattaforma`, `descrizioneSito`, `consentiIndicizzazione`, `ottimizzazioneUrl`, `attivaCache`, `linguaSito`, `nomeMittente`, `emailMittente`, `utenteSmtp`, `hostSmtp`, `portaSmtp`, `passwordSmtp`, `disattivaAccessoUtenti`, `messaggioAccessoDisattivato`, `registrazioneUtenti`, `gruppoDefault`, `statoInizialeNuoviUtenti`, `mailNotifiche`,`inviaNotificaMailNuovoUtente`, `inviaNotificaMailNuoveComunicazioni`, `accessoFacebook`, `accessoGoogle`,`coloreBarraSuperiore`,`coloreTestoBarraSuperiore`,`attivaApi`, `emailApi`, `idAppFacebook`, `secretAppFacebook`, `filtraggioIP`, `indirizziIPAmmessi`, `indirizziIPBannati`, `filtraggioIPAreaUtenti`, `indirizziIPAmmessiAreaUtenti`, `indirizziIPBannatiAreaUtenti`, `cambioPasswordObbligatorio`, `attivaContabilita`, `tipoContabilita`, `percentualeIva`, `intestazioneDocumentiFiscali`, `gruppoClienti`, `gruppoFornitori`,`ottimizzaImmaginiCaricate`,`altezzaImmagine`,`generaThumbnail`,`altezzaThumbnail`,`comprimiCss`,`comprimiJs`) 
                                                                VALUES (NULL, 'no', 'template/logo.svg', 'template/logo-mobile.svg', '', 'Accesso a Geecom Admin', '', 'no', 'no','', 'Home page di Geecom Admin', '', '1', '0', '2', '0', '3', '0', 'si','4', '0', '5', '0', '6', '0', '$urlPiattaforma', '$nomePiattaforma', '', 'no', 'no','', 'italiano', '', '', '', '', 0, '', 'no', 'Accesso disattivato dall\'amministratore', 'no', '0', 'attivato','$email','no','si','no', 'no', 'bg-primary','navbar-dark','no', 'no', '','', '','', '', 'no', '', '', 'Mai', '$attivaContabilita', '$tipoContabilita', '0', '', '0', '0','si',1080,'no',240,'no','no')";

    // inizializzo la tabella impostazioniLingue
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_impostazioniLingue VALUES (NULL,'italiano', 'si','1','','0','','0','','0', '','0')";

    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_statistiche VALUES(NULL,0,0,'$data','$data');";
    
    //crea il menu principale
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_menu VALUES (NULL,'Menu principale','si')";

    //query per creare le voci di base (home e contatti) e le inserisce nel menu principale
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_vociMenu (`id`,`idMenu`,`nome`,`idContenuto`,`vocePadre`,`icona`,`immagine`,`tipo`,`link`,`posizione`,`gruppoSpecifico`) VALUES
        (NULL,1,'Home',2,0,'','','link','index.php?alias=home-page',1,0),
        (NULL,1,'Comunicazioni',0,0,'','','link','comunicazioni.php?tipo=comunicazione',2,0),
        (NULL,1,'Segnalazioni',0,0,'','','link','comunicazioni.php?tipo=segnalazione',3,0),
        (NULL,1,'Ticket',0,0,'','','link','comunicazioni.php?tipo=ticket',4,0);";
    
     //query per creare il footer. In Geecom viene visto come una sorta di contenuto
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_footer` VALUES (NULL, 'italiano', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','bg-dark','bg-primary','text-dark'),"
                                                                                            . "(NULL, 'inglese', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','bg-dark','bg-primary','text-dark'),"
                                                                                            . "(NULL, 'tedesco', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','bg-dark','bg-primary','text-dark'),"
                                                                                            . "(NULL, 'francese', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','bg-dark','bg-primary','text-dark'),"
                                                                                            . "(NULL, 'spagnolo', '<p><span class=\"text-muted\">Note del sito. Personalizza questo spazio dall\'area amministrativa, sezione impostazioni</span></p>', 'no', '', '', '', '', '', '', '', '', '','bg-dark','bg-primary','text-dark');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_leggeCookie` (`id`, `lingua`, `attivaBarraCookie`, `durataCookie`, `testoBarraCookie`, `headCodiciCookie`, `fineBodyCookie`, `testoPulsanteAccetto`, `testoPulsanteNonAccetto`, `testoPulsanteMaggioriInformazioni`, `mostraPulsanteNonAccetto`, `mostraPulsanteMaggioriInformazioni`, `paginaMaggioriInformazioni`) "
            . "VALUES (NULL, 'italiano', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),"
            . "(NULL, 'inglese', 'si', 90 ,'<p class=\"mb-3\">This website uses cookies to give you the best experience on our website.</p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),"
            . "(NULL, 'tedesco', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),"
            . "(NULL, 'francese', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4),"
            . "(NULL, 'spagnolo', 'si', 90 ,'<p class=\"mb-3\">Questo sito utilizza i cookies per migliorare la tua esperienza di navigazione. </p>', '', '', 'Accetto', 'Non accetto', 'Maggiori informazioni', 'si', 'si',4);";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_inclusioni` (`id`, `inizioHead`, `fineHead`, `inizioBody`, `fineBody`, `footer`) VALUES (NULL, '', '', '', '', '')";

    //creazione pagina login
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','no','0','0','si','pubblicato','','paginaDiServizio.php','si','','Login','Login','no','','','login','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 34, 1, 'contenuto', 0, 1, NULL, NULL, NULL, '', '', '', '', NULL);";
    
    //creazione pagina registrazione
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','no','0','0','si','pubblicato','','paginaDiServizio.php','si','','Registrazione','Registrazione','no','','','registrazione','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 35, 2, 'contenuto', 0, 1, NULL, NULL, NULL, '', '', '', '', NULL);";
    
    //creazione pagina Home page
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','templateBase.php','si','','Home page','Home page','si','','','home-page','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `aTuttaLarghezza`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 26, 3, 'contenuto', 0, 1, 'Questa è la home page della tua area riservata! Personalizzala dal pannello amministrativo', NULL, NULL, '', 'si', '', '', '', 'opzioneClasseColonne=col-12;');";
    
    //creazione pagina profilo
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','templateBase.php','si','','Profilo','Profilo','si','','','profilo','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 39, 4, 'contenuto', 0, 1, NULL, NULL, NULL, '', '', '', '', NULL);";
        
    //creazione pagina recupero password
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','no','0','0','si','pubblicato','','paginaDiServizio.php','si','','Recupera password','Recupera password','no','','','recupera-password','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 37, 5, 'contenuto', 0, 1, NULL, NULL, NULL, '', '', '', '', NULL);";
        
    //creazione pagina notifiche
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','templateBase.php','si','','Notifiche','Notifiche','no','','','notifiche','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`, `posizione`, `testo`, `codiceGenerato`, `script`, `idSezione`, `classeSezione`, `animazione`, `coloreSfondo`, `altreOpzioni`) VALUES
(NULL, 38, 6, 'contenuto', 0, 1, NULL, NULL, NULL, '', '', '', '', NULL);";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','templateBase.php','si','','Informtiva sulla privacy','Informtiva sulla privacy','no','','','informativa-sulla-privacy','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_composizionePagine` (`id`, `idComponente`, `idPagina`,`tipoElemento`, `idElemento`, `posizione`, `testo`, `idSezione`, `classeSezione`,`altreOpzioni`) VALUES(NULL, 26, 7,'contenuto', 0, 1, '<p>Questa &egrave; la tua informativa sulla privacy. Ti abbiamo preparato una
             pagina base che dovrai leggere ed eventualmente adattare al tuo caso specifico. Se non hai inserito script 
            aggiuntivi (esempio per scopi pubblicitari) ti baster&agrave; rimuovere queste righe introduttive, altrimenti 
            dovrai modificarla aggiungendo i vari script che hai aggiunto e spiegando il loro comportamento. Se vuoi 
            essere aiutato in questa operazione puoi utilizzare il nostro portfolio di generazione policy.</p>\r\n<p>
            <br />In questa pagina $nome $cognome, titolare del sito internet $nomePiattaforma intende informare come avvengono il 
            trattamento e la protezione dei dati personali dei soggetti (utenti) che vi navigano all\'interno, con accesso 
            diretto dalla home page oppure da pagine interne.<br /><br /><b>Cookie tecnici</b><br />IL sito utilizza cookie tecnici 
            per stabilire se il \'utente &egrave; loggato oppure no. Le informazioni memorizzate servono esclusivamente ai fini del 
            di offrire una buona esperienza d\'uso per l\'utente e memorizzano, tra le altre cose, l\'indirizzo email, il nome e la data 
            dell\'ultimo accesso dell\'utente.<br /><br /><b>Modulo contatti</b><br />Nessuna informazione viene salvata nei database 
            del sito durante l\'invio di informazioni tramite i moduli di contatto. I dati vengono utilizzati esclusivamente per 
            recapitare l\'email al destinatario del sito.<br /><br /><b>Commenti</b><br />Il sito da la possibilit&agrave; di commentare 
            articoli, per farlo richiede di inserire, oltre al commento, nome ed email. Il dati inseriti tramite questa form vengono
            poi salvati nel database. Solo il nome e il commento vengono mostrati pubblicamente.<br />
            <br><br><b>Finalità del trattamento</b></br>
            I dati per le statistiche del sito vengono raccolti in forma anonima e sono volti unicamente a determinare quali sono gli 
            articoli o le categorie più interessanti, i banner più cliccati (e quando). I dati immessi nei moduli di contatto sono 
            raccolti al solo fine di poter rispondere alle mail o contattare gli autori dei commenti in caso di necessità.
            <br><br><b>I ruoli e le responsabilità in ambito privacy</b><br>
            I dati personali sono trattati da $nome $cognome, in qualità di titolare del trattamento. Informazioni più dettagliate sui nominativi dei responsabili del trattamento potranno essere richieste inviando una mail a $email.
            <br><br><b>Modalità del trattamento di dati</b><br>
            Il trattamento dei dati personali viene effettuato prevalentemente con software e supporti elettronici (DB, piattaforme di CRM, ecc.) per il tempo strettamente necessario a conseguire gli scopi per i quali i dati sono stati raccolti e, comunque, in conformità alla vigente normativa privacy.
            <br><br><b>Diritto all\'oblio</b><br>
            In base alla normativa vigente, l\'utente ha il diritto di richiedere il diritto all\'oblio, ossia la cancellazione di tutti i dati personali (inclusi gli eventuali commenti) in possesso di $nomePiattaforma. Per esercitare tale diritto è necessario inviare una mail a $email</p>', '', '','opzioneClasseColonne=col-12;');";
    
    //creazione riga per contenere le visite giornaliere, va inizializzata con la data dell'installazione
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO `geecAd_visiteGiornaliere` (`id`, `numeroVisite`, `dataCorrente`) VALUES (NULL, '0', '$data');";
    
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecAd_etichette (`id`, `nome`, `tipo`, `dataCreazione`) VALUES(NULL,'Affitto','contabilita','$data'),(NULL,'Bollette','contabilita','$data'),(NULL,'Imposte e tasse','contabilita','$data'),(NULL,'Bonifico','metodoPagamento','$data'),(NULL,'Contanti','metodoPagamento','$data'),(NULL,'Paypal','metodoPagamento','$data'),(NULL,'Stripe','metodoPagamento','$data');";
   
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <title>Installazione di Geecom Admin</title>
        <?php
            include "../amministrazione/include/cssBaseAreaAmministrativa.php";
        ?>
    </head>
    <body class="bg-primary">
        <main role="main" class="d-flex align-items-center mt-0">
            <div id="installazione" class="container">
                <div class="row">
                    <div class="col-sm-8 col-md-6 mx-auto">
                        <div class="card box-shadow-lite mb-4">
                            <div class="row">
                                <div class="col-8 col-lg-6 mx-auto">
                                    <img class="img-fluid logo mb-4" src="../template/img/geecom.svg" />
                                </div>
                                <div class="col-12">
                                    <p>Installazione di Geecom <?php echo $infoGeecom["nomeProdotto"] ?>.</p>       
                                    
                                    <?php 
                                        if(!isset($_SESSION["altriProdotti"])) { //se la sessione non è stata settata non ci sono altri prodotti geecom
                                            //esegue in blocco le query di configurazione
                                            $geecomDb->eseguiInsiemeDiQuery($queryTabelleComuni);
                                            echo"<div class=\"alert alert-success\">Creazione tabelle base di Geecom completata</div>";
                                        }
                                        else { // se sono presenti altri prodotti deve essere solo aggiornata la cartella prodotti
                                            $queryCreazioneAdmin = "UPDATE geec_prodotti SET installato = 'si', versione = '{$infoGeecom["versione"]}', percorso = '$cartellaAmministrazione' WHERE nome LIKE 'Admin'";
                                            $geecomDb->eseguiQueryScrittura($queryCreazioneAdmin);
                                            
                                            // inserisco una sola configurazione per Geecom Admin, che diventa quella predefinita
                                            $queryInserimentoConfigurazione = "INSERT INTO `geec_configurazioniAspetto`  
        VALUES (NULL, 'Configurazione di base Admin','Stai usando la configurazione predefinita dei colori di Geecom', 'no','si','no','template/logoGeecom.svg','template/logo-mobile.svg','template/favicon.ico', '50px', '200px', '50px', '300px', 'bg-dark', 'navbar-dark', 'https://fonts.googleapis.com/css?family=Raleway:400,700|Roboto:300,400,700&display=swap','font-family:\'Raleway\', sans-serif;','font-family:\'Roboto\', sans-serif;', '#018394', '#dd3b15', '#28a745', '#335C67', '#f8f9fa', '#0d1b1e', '#f7a616', '#dc3545','#016c7a', '#b53112', '#218838', '#2f5453', '#e2e6ea', '#0c191c','#cb8813', '#c82333','#01606c', '#a12b10', '#1e7e34','#2a4c55', '#dae0e5', '#0b1719', '#b47b11', '#bd2130','576px', '768px', '992px', '1200px','no','col-md-4 col-xl-3 sticky-top align-self-start','col-md-8 col-xl-9 mx-auto','si','col-md-4 col-xl-3 sticky-top align-self-start','link')";
                                            $geecomDb->eseguiQueryScrittura($queryInserimentoConfigurazione);
                                            echo"<div class=\"alert alert-success\">Tabella Geecom aggiornata</div>";
                                        }

                                        //esegue in blocco le query che creano le tabelle dle database
                                        $geecomDb->eseguiInsiemeDiQuery($queryCreazioniTabelle);
                                        echo"<div class=\"alert alert-success\">Creazione tabelle di Geecom Admin completata</div>";

                                        if($attivaContabilita=="si") {
                                            $idGruppoClienti   = $geecomDb->eseguiQueryCreazione("INSERT INTO geec_gruppi VALUES(NULL,'Clienti','','','$data')");
                                            $idGruppoFornitori = $geecomDb->eseguiQueryCreazione("INSERT INTO geec_gruppi VALUES(NULL,'Fornitori','','','$data')");
                                        }
                                        else {
                                            $idGruppoClienti   = 0;
                                            $idGruppoFornitori = 0;
                                        }

                                        //esegue in blocco le query di configurazione
                                        $geecomDb->eseguiInsiemeDiQuery($queryDiConfigurazione);
                                        echo"<div class=\"alert alert-success\">Configurazione eseguita</div>";

                                        $dataOggi = date("Y-m-d");
                                        $queryCreazioneAdmin = "INSERT INTO geec_utenti VALUES(NULL,'$email','$password','super admin','$nome','$cognome','','','', '', '', '', '', NULL, '', '', '', '', '', '','', '', '','attivato', 'si', '', '$dataOggi', '$dataOggi')";
                                        $geecomDb->eseguiQueryScrittura($queryCreazioneAdmin);
                                        echo"<div class=\"alert alert-success\" role=\"alert\">Utente amministratore creato</div>";

                                        rename(realpath(str_replace("installazione","amministrazione",__DIR__)), str_replace("installazione","$cartellaAmministrazione",__DIR__));
                                        echo"<div class=\"alert alert-success\" role=\"alert\">Installazione terminata!</div>";

                                        echo"<div class=\"alert alert-warning\">Salva il link di accesso alla tua area amministrativa: <b>$linkAreaRiservata</b></div>";
                                    ?>

                                    <a href="<?php echo $linkAreaRiservata ?>" class="btn btn-success btn-block">Vai all'area amministrativa</a>

                                    <div class="card m-0 bg-light p-3 mt-3">
                                        <strong class="text-center text-primary">Sei nuovo di Geecom?</strong>
                                        <hr>
                                        
                                        <div class="row">
                                            <div class="col-md-4 text-center">
                                                <a href="https://www.geecom.org/?alias=impara-ad-utilizzare-geecom" target="_blank"> 
                                                    <i class="fas fa-rocket d-block fa-2x text-primary mb-2"></i>
                                                    Comincia da qui
                                                </a>
                                            </div>
                                            
                                            <div class="col-md-4 text-center">
                                                <a href="https://www.geecom.org/?alias=chiedi" target="_blank"> 
                                                    <i class="fas fa-question d-block fa-2x text-primary mb-2"></i>
                                                   Chiedi</a>
                                            </div>
                                            
                                            <div class="col-md-4 text-center">
                                                <a href="https://www.geecom.org/scaricaFile.php?id=2" target="_blank"> 
                                                    <i class="fas fa-book d-block fa-2x text-primary mb-2"></i>
                                                    Scarica il manuale</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- /container -->
        </main>
        
        <?php
            include "../amministrazione/include/footer.php";
        ?>
        
        <!-- Optional JavaScript -->
	<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
	<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.1/js/bootstrap.min.js" integrity="sha384-smHYKdLADwkXOn1EmN1qk/HfnUcbVRZyYmZ4qpPea6sjB/pTJ0euyQp0Mk8ck+5T" crossorigin="anonymous"></script>  
	
	<!-- Tooltips e Popover -->
	<script>
            $(function () {
              $('[data-toggle="tooltip"]').tooltip()
            }) 
	</script>
	  
  </body>
</html>
